/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.config.IEditModeConfig;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.gui.ingredients.GuiIngredientProperties;
import mezz.jei.common.gui.overlay.IIngredientGrid;
import mezz.jei.common.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.common.gui.overlay.options.HorizontalAlignment;
import mezz.jei.common.gui.overlay.options.VerticalAlignment;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IKeyBindings;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.handlers.DeleteItemInputHandler;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.render.ElementRenderer;
import mezz.jei.common.render.IngredientListRenderer;
import mezz.jei.common.render.IngredientListSlot;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class IngredientGrid
implements IRecipeFocusSource,
IIngredientGrid {
    private static final int INGREDIENT_PADDING = 1;
    public static final int INGREDIENT_WIDTH = GuiIngredientProperties.getWidth(1);
    public static final int INGREDIENT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final IIngredientGridConfig gridConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientListRenderer ingredientListRenderer;
    private final DeleteItemInputHandler deleteItemHandler;
    private final IngredientGridTooltipHelper tooltipHelper;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;

    public IngredientGrid(RegisteredIngredients registeredIngredients, IIngredientGridConfig gridConfig, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, IClientConfig clientConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, IModIdHelper modIdHelper, IConnectionToServer serverConnection, IKeyBindings keyBindings) {
        this.gridConfig = gridConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientListRenderer = new IngredientListRenderer(editModeConfig, worldConfig, registeredIngredients);
        this.tooltipHelper = new IngredientGridTooltipHelper(registeredIngredients, ingredientFilterConfig, worldConfig, modIdHelper, keyBindings);
        this.deleteItemHandler = new DeleteItemInputHandler(this, worldConfig, clientConfig, serverConnection);
    }

    public IUserInputHandler getInputHandler() {
        return this.deleteItemHandler;
    }

    public int size() {
        return this.ingredientListRenderer.size();
    }

    public int maxWidth() {
        return this.gridConfig.getMaxColumns() * INGREDIENT_WIDTH;
    }

    public int maxHeight() {
        return this.gridConfig.getMaxRows() * INGREDIENT_HEIGHT;
    }

    public boolean updateBounds(ImmutableRect2i availableArea, Collection<ImmutableRect2i> exclusionAreas) {
        this.ingredientListRenderer.clear();
        this.area = IngredientGrid.calculateBounds(this.gridConfig, availableArea, INGREDIENT_WIDTH, INGREDIENT_HEIGHT);
        if (this.area.isEmpty()) {
            return false;
        }
        for (int y = this.area.getY(); y < this.area.getY() + this.area.getHeight(); y += INGREDIENT_HEIGHT) {
            for (int x = this.area.getX(); x < this.area.getX() + this.area.getWidth(); x += INGREDIENT_WIDTH) {
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x, y, INGREDIENT_WIDTH, INGREDIENT_HEIGHT, 1);
                ImmutableRect2i stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.ingredientListRenderer.add(ingredientListSlot);
            }
        }
        return true;
    }

    private static ImmutableRect2i calculateBounds(IIngredientGridConfig config, ImmutableRect2i availableArea, int ingredientWidth, int ingredientHeight) {
        int columns = Math.min(availableArea.getWidth() / ingredientWidth, config.getMaxColumns());
        int rows = Math.min(availableArea.getHeight() / ingredientHeight, config.getMaxRows());
        if (rows < config.getMinRows() || columns < config.getMinColumns()) {
            return ImmutableRect2i.EMPTY;
        }
        int width = columns * ingredientWidth;
        int height = rows * ingredientHeight;
        int x = switch (config.getHorizontalAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case HorizontalAlignment.LEFT -> availableArea.getX();
            case HorizontalAlignment.CENTER -> availableArea.getX() + (availableArea.getWidth() - width) / 2;
            case HorizontalAlignment.RIGHT -> availableArea.getX() + (availableArea.getWidth() - width);
        };
        int y = switch (config.getVerticalAlignment()) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalAlignment.TOP -> availableArea.getY();
            case VerticalAlignment.CENTER -> availableArea.getY() + (availableArea.getHeight() - height) / 2;
            case VerticalAlignment.BOTTOM -> availableArea.getY() + (availableArea.getHeight() - height);
        };
        return new ImmutableRect2i(x, y, width, height);
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public void draw(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        this.ingredientListRenderer.render(poseStack);
        if (this.isMouseOver(mouseX, mouseY) && !this.deleteItemHandler.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getIngredientRenderer).flatMap(Optional::stream).map(ElementRenderer::getArea).findFirst().ifPresent(area -> IngredientGrid.drawHighlight(poseStack, area));
        }
    }

    public static void drawHighlight(class_4587 poseStack, ImmutableRect2i area) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        class_332.method_25294((class_4587)poseStack, (int)area.getX(), (int)area.getY(), (int)(area.getX() + area.getWidth()), (int)(area.getY() + area.getHeight()), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void drawTooltips(class_310 minecraft, class_4587 poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.deleteItemHandler.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                this.deleteItemHandler.drawTooltips(poseStack, mouseX, mouseY);
            } else {
                this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getTypedIngredient).flatMap(Optional::stream).findFirst().ifPresent(ingredient -> this.tooltipHelper.drawTooltip(poseStack, mouseX, mouseY, ingredient));
            }
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientListRenderer.getSlots().filter(s -> s.isMouseOver(mouseX, mouseY)).map(IngredientListSlot::getIngredientRenderer).flatMap(Optional::stream);
    }

    public <T> Stream<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        return this.ingredientListRenderer.getSlots().map(IngredientListSlot::getTypedIngredient).flatMap(Optional::stream).map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    public void set(int firstItemIndex, List<ITypedIngredient<?>> ingredientList) {
        this.ingredientListRenderer.set(firstItemIndex, ingredientList);
    }
}

